import 'package:admin_desktop/domain/models/data/comments_data.dart';


class ShopCommentsPaginateResponse {
  List<CommentsData>? data;

  ShopCommentsPaginateResponse({
    this.data,
  });

  ShopCommentsPaginateResponse copyWith({
    List<CommentsData>? data,
  }) =>
      ShopCommentsPaginateResponse(
        data: data ?? this.data,
      );

  factory ShopCommentsPaginateResponse.fromJson(Map<String, dynamic> json) =>
      ShopCommentsPaginateResponse(
        data: json["data"] == null
            ? []
            : List<CommentsData>.from(
                json["data"]!.map((x) => CommentsData.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}
